
-- Fleming

set sql_safe_updates=0;


-- USER_PROGRAM_COURSE_ASSOCIATION   
-- RCPNT_TYPE_USER_DTP      
SET @userProgramCourseAssociation=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.`code` as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
        LEFT JOIN
    multi_language ml ON ml.id = T3.correspondence_language
WHERE
    T2.id IN (namedParams) group by T1.userId" WHERE `dataProviderId`=@userProgramCourseAssociation;
 
 
 -- USER_PROGRAM_COURSE_ASSOCIATION  
 -- SYSADMIN_DL      
SET @userProgramCourseAssociation2=(SELECT id FROM dtprovider WHERE `dataProviderName`='SYSADMIN_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
     ml.`code` as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        INNER JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    multi_language ml ON ml.id = T3.correspondence_language

WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@userProgramCourseAssociation2;
    

 -- MSG_ATTENDANCE_STUDENT_CD  
 -- RCPNT_MSG_ATTENDANCE_STUDENT_CD      
SET @msgAttendanceStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_MSG_ATTENDANCE_STUDENT_CD');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T14.`id` AS ID,
    T5.`firstName` AS FIRST_NAME,
    T5.`middleName` AS MIDDLE_NAME,
    T5.`lastName` AS LAST_NAME,
    T6.`salutationName` AS SALUTATION,
    T2.`dateOfAttendance` AS DATE_OF_ATTENDANCE,
    T5.`emailId` AS EMAIL_ID,
    T5.`mobileNumber` AS MOBILE_NO,
    T5.`mobileCountryCode` AS MOBILE_CODE,
    T7.`itemValue` AS ATTENDANCE_MARKING_TYPE,
     ml.`code` as LANGUAGE_KEY,
    REPLACE(CONCAT(SUBSTRING(T1.`attendanceStatus`, 1, 1),
                SUBSTRING(LOWER(T1.`attendanceStatus`),
                    2)),
        '_',
        ' ') AS STATUS,
    (CASE
        WHEN
            (T7.itemValue = 'Present'
                AND T7.attendanceStatus = 'PRESENT')
        THEN
            CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T7.attendanceStatus, 2)))
        WHEN
            (T7.itemValue = 'Absent'
                AND T7.attendanceStatus = 'ABSENT')
        THEN
            CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T7.attendanceStatus, 2)))
        ELSE CONCAT(T7.itemValue,
                '/',
                CONCAT(UCASE(LEFT(T7.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T7.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS
FROM
    `student_program_attendance_details` T1
        INNER JOIN
    `student_program_attendance` T2 ON T1.`attendanceId` = T2.`id`
        INNER JOIN
    `admission` T3 ON T3.`id` = T1.`admissionId`
        INNER JOIN
    `students` T4 ON T4.`userId` = T3.`studentId`
        INNER JOIN
    `persons` T5 ON T5.`id` = T4.`personId`
        INNER JOIN
    `users` T14 ON T14.`id` = T4.`userId`
        LEFT JOIN
    `salutations` T6 ON T5.`salutationId` = T6.`id`
        LEFT JOIN
    `attendance_marking_type` AS T7 ON T7.`id` = T1.`attendanceMarkingTypeId`
		LEFT JOIN
     multi_language ml ON ml.id = T5.correspondence_language    
WHERE
    T14.`id` IN (namedParams)
        AND T2.`id` = (SELECT 
            MAX(attendanceId)
        FROM
            `student_program_attendance_details` T9
                INNER JOIN
            `student_program_attendance` T10 ON T9.`attendanceId` = T10.`id`
                INNER JOIN
            `admission` T11 ON T11.`id` = T9.`admissionId`
                INNER JOIN
            `students` T12 ON T12.`userId` = T11.`studentId`
                INNER JOIN
            `persons` T13 ON T13.`id` = T12.`personId`
                INNER JOIN
            `users` T14 ON T14.`id` = T12.`userId`
        WHERE
            T14.`id` IN (namedParams))" WHERE `dataProviderId`=@msgAttendanceStudent;


-- MSG_ATTENDANCE_STUDENT_SWIPE  
 -- MSG_ATTENDANCE_STUDENT_RCPNT      
SET @msgAttendanceStudentSwipe=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_ATTENDANCE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select
T1.id as ID,
T12.salutationName as STUDENT_SALUTATION,
T1.firstName as STUDENT_FIRSTNAME,
T1.lastName as STUDENT_LASTNAME,
T13.salutationName as GUARDIAN_SALUTATION,
T6.firstName as GUARDIAN_FIRSTNAME,
T6.lastName as GUARDIAN_LASTNAME,
T11.addressText as SWIPE_LOCATION,
DATE_FORMAT(T4.punchTime,'%b %d %Y %h:%i %p') as PUNCH_TIME,
T15.primaryeEmailId as EMAIL_ID,
T15.cellNo as MOBILE_NO,
ml.`code` as LANGUAGE_KEY
from persons T1
INNER JOIN attendance_user_mapping T2 on T2.academiaUserId = T1.id
INNER JOIN attendance_machine_user T3 on T3.userMappingId = T2.id
INNER JOIN attendance_machine_log T4 on T4.attendanceMachineUserId = T3.id
INNER JOIN attendance_machine_location T9 on T9.attendanceMachineId = T3.attendanceMachineId
INNER JOIN location_addresses T10 on T10.locationId = T9.locationId
INNER JOIN address T11 on T11.id = T10.addressId
INNER JOIN salutations T12 on T1.salutationId = T12.id
INNER JOIN persons T6 on T6.id = ( 
	SELECT T7.relatedPersonId from person_relationships T7
	where T7.relationship = 
		case
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship='LOCAL_GUARDIAN') then 'LOCAL_GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship='GUARDIAN') then 'GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship='FATHER') then 'FATHER'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T1.id and T8.relationship='MOTHER') then 'MOTHER'
		end
)
INNER JOIN salutations T13 on T6.salutationId = T13.id
INNER JOIN person_addresses T14 on T14.personId = T6.id 
INNER JOIN address T15 on T15.id = T14.addressId
INNER JOIN (
SELECT MAX(T20.id) MAXID from persons T17
	INNER JOIN attendance_user_mapping T18 on T18.academiaUserId = T17.id
	INNER JOIN attendance_machine_user T19 on T19.userMappingId = T18.id
	INNER JOIN attendance_machine_log T20 on T20.attendanceMachineUserId = T19.id
WHERE T17.id = (namedParams)
)T16 on T4.id = T16.MAXID
LEFT JOIN
multi_language ml ON ml.id = T1.correspondence_language
where T1.id =(namedParams) AND T14.whetherPrimary = 1" WHERE `dataProviderId`=@msgAttendanceStudentSwipe;


-- MSG_WEEKLY_ATTENDACE_REPORT  
 -- MSG_WEEKLY_ATTENDANCE_RCPNT      
SET @msgWeeklyAttendanceReport=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_WEEKLY_ATTENDANCE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select 
tmp1.ID as ID,
tmp1.TOTAL_PRESENT as `TOTAL_PRESENT`,
tmp1.TOTAL_ABSENT as `TOTAL_ABSENT`,
tmp1.PRESENT_PERCENTAGE as `PRESENT_PERCENTAGE`,
tmp1.ABSENT_PERCENTAGE as `ABSENT_PERCENTAGE`,
tmp1.FIRST_NAME as `FIRST_NAME`,
tmp1.LAST_NAME as `LAST_NAME`,
tmp1.MOBILE_NO as `MOBILE_NO`,
tmp1.MOBILE_CODE as `MOBILE_CODE`,
tmp1.EMAIL_ID as `EMAIL_ID`,
tmp1.LANGUAGE_KEY as `LANGUAGE_KEY`,
IFNULL(tmp2.DATE, DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE1`,
IF(tmp2.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp2.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp2.DATEDETAILS),2)),'_',' ')) as `DATE1DETAILS`,
IFNULL(tmp3.DATE, DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE2`,
IF(tmp3.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp3.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp3.DATEDETAILS),2)),'_',' ')) as `DATE2DETAILS`,
IFNULL(tmp4.DATE, DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE3`,
IF(tmp4.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp4.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp4.DATEDETAILS),2)),'_',' ')) as `DATE3DETAILS`,
IFNULL(tmp5.DATE, DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE4`,
IF(tmp5.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp5.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp5.DATEDETAILS),2)),'_',' ')) as `DATE4DETAILS`,
IFNULL(tmp6.DATE, DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE5`,
IF(tmp6.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp6.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp6.DATEDETAILS),2)),'_',' ')) as `DATE5DETAILS`,
IFNULL(tmp7.DATE, DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE6`,
IF(tmp7.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp7.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp7.DATEDETAILS),2)),'_',' ')) as `DATE6DETAILS`,
IFNULL(tmp8.DATE, DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE7`,
IF(tmp8.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp8.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp8.DATEDETAILS),2)),'_',' ')) as `DATE7DETAILS`
from 
(
select T3.studentId as `ID`,
count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,
count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,
ROUND((count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,
ROUND((count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,
T5.firstName as `FIRST_NAME`,
T5.lastName as `LAST_NAME`,
T5.mobileNumber as `MOBILE_NO`,
T5.mobileCountryCode as `MOBILE_CODE`,
T5.emailId as `EMAIL_ID`,
ml.`code` as LANGUAGE_KEY
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
left join  multi_language ml ON ml.id = T5.correspondence_language
where T3.studentId in (namedParams)
and (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d'))
group by T3.studentId
order by T3.studentId
) tmp1
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp2 on tmp2.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp3 on tmp3.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp4 on tmp4.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp5 on tmp5.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp6 on tmp6.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp7 on tmp7.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp8 on tmp8.studentId = tmp1.`ID`" WHERE `dataProviderId`=@msgWeeklyAttendanceReport;

-- MSG_WEEKLY_ATTENDACE_REPORT_PARENTS  
-- MSG_WEEKLY_ATTENDANCE_PARENTS_RCPNT      
SET @msgWeeklyAttendanceReportParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_WEEKLY_ATTENDANCE_PARENTS_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select 
tmp1.ID as ID,
tmp1.TOTAL_PRESENT as `TOTAL_PRESENT`,
tmp1.TOTAL_ABSENT as `TOTAL_ABSENT`,
tmp1.PRESENT_PERCENTAGE as `PRESENT_PERCENTAGE`,
tmp1.ABSENT_PERCENTAGE as `ABSENT_PERCENTAGE`,
tmp1.FIRST_NAME as `FIRST_NAME`,
tmp1.LAST_NAME as `LAST_NAME`,
tmp1.MOBILE_NO as `MOBILE_NO`,
tmp1.EMAIL_ID as `EMAIL_ID`,
tmp1.MOBILE_CODE as `MOBILE_CODE`,
tmp1.LANGUAGE_KEY as `LANGUAGE_KEY`,
IFNULL(tmp2.DATE, DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE1`,
IF(tmp2.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp2.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp2.DATEDETAILS),2)),'_',' ')) as `DATE1DETAILS`,
IFNULL(tmp3.DATE, DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE2`,
IF(tmp3.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp3.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp3.DATEDETAILS),2)),'_',' ')) as `DATE2DETAILS`,
IFNULL(tmp4.DATE, DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE3`,
IF(tmp4.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp4.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp4.DATEDETAILS),2)),'_',' ')) as `DATE3DETAILS`,
IFNULL(tmp5.DATE, DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE4`,
IF(tmp5.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp5.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp5.DATEDETAILS),2)),'_',' ')) as `DATE4DETAILS`,
IFNULL(tmp6.DATE, DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE5`,
IF(tmp6.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp6.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp6.DATEDETAILS),2)),'_',' ')) as `DATE5DETAILS`,
IFNULL(tmp7.DATE, DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE6`,
IF(tmp7.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp7.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp7.DATEDETAILS),2)),'_',' ')) as `DATE6DETAILS`,
IFNULL(tmp8.DATE, DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE7`,
IF(tmp8.DATEDETAILS IS NULL , '-', REPLACE(CONCAT(SUBSTRING(tmp8.DATEDETAILS,1,1),SUBSTRING(LOWER(tmp8.DATEDETAILS),2)),'_',' ')) as `DATE7DETAILS`
from 
(
select T3.studentId as `ID`,
count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_PRESENT`,
count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null)) as `TOTAL_ABSENT`,
ROUND((count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `PRESENT_PERCENTAGE`,
ROUND((count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))/
	(count(IF(T2.attendanceStatus = 'PRESENT',T2.attendanceStatus,null))
    +count(IF(T2.attendanceStatus <> 'PRESENT',T2.attendanceStatus,null))))*100) as `ABSENT_PERCENTAGE`,
T6.firstName as `FIRST_NAME`,
T6.lastName as `LAST_NAME`,
T6.mobileNumber as `MOBILE_NO`,
T6.mobileCountryCode as `MOBILE_CODE`,
T6.emailId as `EMAIL_ID`,
ml.code as LANGUAGE_KEY
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId 
LEFT JOIN multi_language ml on T5.correspondence_language=ml.id
inner join persons T6 on T6.id =
( 
	SELECT T7.relatedPersonId from person_relationships T7
	where T7.personId = T5.id AND T7.relationship = 
		case
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='LOCAL_GUARDIAN') then 'LOCAL_GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='GUARDIAN') then 'GUARDIAN'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='FATHER') then 'FATHER'
			when exists (select T8.relationship from person_relationships T8 where T8.personId = T5.id and T8.relationship='MOTHER') then 'MOTHER'
		end
)
where T3.studentId in (namedParams)
and (T1.dateOfAttendance BETWEEN DATE_FORMAT(SUBDATE(NOW(),7),'%Y-%m-%d') AND DATE_FORMAT(NOW(),'%Y-%m-%d'))
group by T3.studentId
order by T3.studentId
) tmp1
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),7),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp2 on tmp2.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),6),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp3 on tmp3.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),5),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp4 on tmp4.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),4),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp5 on tmp5.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),3),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp6 on tmp6.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),2),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp7 on tmp7.studentId = tmp1.`ID`
left join (
select T3.studentId,IFNULL(T1.dateOfAttendance , DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')) as `DATE`,
IFNULL(T2.attendanceStatus , '-') as `DATEDETAILS`
from student_program_attendance T1
inner join student_program_attendance_details T2 on T2.attendanceId = T1.id
inner join admission T3 on T3.id = T2.admissionId
inner join students T4 on T4.userId = T3.studentId
inner join persons T5 on T5.id = T4.personId
where T3.studentId in (namedParams)
and dateOfAttendance = DATE_FORMAT(subdate(now(),1),'%Y-%m-%d')
group by T3.studentId 
order by T3.studentId
) tmp8 on tmp8.studentId = tmp1.`ID`" WHERE `dataProviderId`=@msgWeeklyAttendanceReportParent;



-- TIME_TABLE_CHANGE  
-- TIME_TABLE_CHANGE_RECIPIENT_INFO      
SET @timeTableChange=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_CHANGE_RECIPIENT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.userId AS ID,
    T2.`firstName` AS FIRST_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.`code` as LANGUAGE_KEY
FROM
    students T1
        LEFT JOIN
    persons T2 ON T1.personId = T2.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
		LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
WHERE
    T1.userId IN (namedParams)
GROUP BY T1.userId" WHERE `dataProviderId`=@timeTableChange;


-- MSG_COURSEWISE_WEEKLY_ATTENDACE_REPORT  
-- MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT      
SET @msgCourseWeeklyAttendance=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COURSEWISE_WEEKLY_ATTENDANCE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.studentId AS ID,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobilecountrycode AS MOBILE_CODE,
    T3.nameToBePrinted AS COURSE_NAME,
    T3.courseCode AS COURSE_CODE,
    T11.componentType AS COMPONENT_DESC,
    T9.firstName AS FACULTY_FIRSTNAME,
    T9.lastName AS FACULTY_LASTNAME,
    T10.salutationName AS SALUTATION,
    T15.printName AS BATCH_NAME,
    T16.programNameToBePrint AS PROGRAM_NAME,
    T17.printName AS PERIOD_NAME,
    T18.displayName AS ACADEMY_NAME,
     ml.code as LANGUAGE_KEY,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_SESSIONS`,
    COUNT(IF(scad.attendanceStatus = 'PRESENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_PRESENT`,
    COUNT(IF(scad.attendanceStatus = 'ABSENT',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_ABSENT`,
    COUNT(IF(scad.attendanceStatus = 'LEAVE',
        scad.attendanceStatus,
        NULL)) AS `TOTAL_LEAVE`,
    ROUND((COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) / (COUNT(IF(scad.attendanceStatus = 'PRESENT',
                scad.attendanceStatus,
                NULL)) + COUNT(IF(scad.attendanceStatus <> 'PRESENT',
                scad.attendanceStatus,
                NULL)))) * 100) AS `PRESENT_PERCENTAGE`
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    courses T3 ON T3.id = sca.courseId
        LEFT JOIN
    course_components T4 ON T4.id = sca.courseComponentId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    staffs T8 ON T8.userId = sca.facultyId
        LEFT JOIN
    persons T9 ON T9.id = T8.personId
        LEFT JOIN
    salutations T10 ON T10.id = T9.salutationId
        LEFT JOIN
    component_type T11 ON T11.id = T4.componentTypeId
        LEFT JOIN
    program_batch_students T14 ON T14.admissionId = T5.id
        LEFT JOIN
    batches T15 ON T15.id = T14.programBatchId
        LEFT JOIN
    programs T16 ON T16.id = T15.programId
        LEFT JOIN
    prog_batch_period_config T17 ON T17.id = T14.progBatchPeriodConfigId
        LEFT JOIN
    academy_location T18 ON T18.id = T16.academyLocationId
		LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.studentId IN (namedParams) and T14.isCurrentPeriod=true and T14.isCurrentSection=true 
GROUP BY sca.courseid , sca.courseComponentId , sca.sectionId , sca.variantId , T5.studentId
ORDER BY sca.courseId DESC" WHERE `dataProviderId`=@msgCourseWeeklyAttendance;


-- STUDENT_MARKED_ABSENT_FOR_THE_SESSION  
-- DAILY_STUDENT_MARKED_ABSENT_FOR_THE_SESSION_RCPNT      
SET @dailyStudentMarked=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_SESSION_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    scad.id AS ID,
    T1.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.emailId AS EMAIL_ID,
    T7.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME,
    T9.salutationName AS SALUTATION_NAME,
    DATE_FORMAT(sca.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(sca.fromTime, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(sca.toTime, '%h:%i %p') AS SLOT_TO,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    student_course_attendance sca
        LEFT JOIN
    student_course_attendance_details scad ON sca.id = scad.attendanceId
        LEFT JOIN
    course_variants T1 ON T1.id = sca.variantId
        LEFT JOIN
    admission T5 ON T5.id = scad.admissionId
        LEFT JOIN
    students T6 ON T6.userId = T5.studentId
        LEFT JOIN
    persons T7 ON T7.id = T6.personId
        LEFT JOIN
    salutations T9 ON T9.id = T7.salutationId
        LEFT JOIN
    academy_location T8 ON T8.id = sca.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T6.userId
        LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id 
WHERE
    scad.attendanceStatus = 'ABSENT'
        AND scad.id IN (namedParams) group by scad.id" WHERE `dataProviderId`=@dailyStudentMarked;
        

-- STUDENT_MARKED_ABSENT_FOR_THE_DAY  
-- DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT      
SET @dailyStudentMarkedday=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_STUDENT_MARKED_ABSENT_FOR_THE_DAY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT     
    T2.id AS ID,
	T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.emailId AS EMAIL_ID,
	T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
	T6.displayName AS ACADEMY_NAME,    
    DATE_FORMAT(T1.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
		LEFT JOIN
    students T4 ON T4.userId = T3.studentId
		LEFT JOIN
    persons T5 ON T5.id = T4.personId
		LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
        LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id
WHERE
	T2.attendanceStatus = 'ABSENT'
	AND T2.id IN (namedParams) group by T2.id" WHERE `dataProviderId`=@dailyStudentMarkedday;    
	

-- ATTENDANCE_DAY_WISE_PARENT_PRESENT_ONLY  
-- STUDENT_MARKED_PRESENT_CD_MS_FATHER_RCPNT      
SET @attendanceDayWiseParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
      LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id  
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'FATHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseParent; 	    
    
    
-- ATTENDANCE_DAY_WISE_PARENT_PRESENT_ONLY  
-- STUDENT_MARKED_PRESENT_CD_MS_MOTHER_RCPNT      
SET @attendanceDayWiseParent2=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_MARKED_PRESENT_CD_MS_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,    
    (case when (T2.itemValue = 'Present' and T2.attendanceStatus = 'PRESENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     when (T2.itemValue = 'Absent' and T2.attendanceStatus = 'ABSENT') then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
    else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) AS ATTENDANCE_STATUS
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T10.facultyId
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
      LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id   
WHERE
T1.id IN (namedParams) AND T2.attendanceStatus = 'PRESENT' AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false" WHERE `dataProviderId`=@attendanceDayWiseParent2;     
    
set sql_safe_updates=1;
    
